/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.recipes;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.dries007.tfc.objects.recipes.RecipeUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ShapedDamageRecipe
extends ShapedOreRecipe {
    private final int damage;

    public ShapedDamageRecipe(ResourceLocation group, CraftingHelper.ShapedPrimer input, @Nonnull ItemStack result, int damage) {
        super(group, result, input);
        this.damage = damage;
    }

    @Nonnull
    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inventoryCrafting) {
        NonNullList remainingItems = NonNullList.func_191197_a((int)inventoryCrafting.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack itemstack = inventoryCrafting.func_70301_a(i);
            if (!itemstack.func_190926_b() && itemstack.func_77973_b().func_77645_m()) {
                remainingItems.set(i, (Object)this.damageStack(itemstack));
                continue;
            }
            remainingItems.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        return remainingItems;
    }

    @Nonnull
    public String func_193358_e() {
        return this.group == null ? "" : this.group.toString();
    }

    private ItemStack damageStack(ItemStack stack) {
        ItemStack damagedStack = stack.func_77946_l();
        EntityPlayer player = ForgeHooks.getCraftingPlayer();
        if (player != null) {
            damagedStack.func_77972_a(this.damage, (EntityLivingBase)player);
        }
        return damagedStack;
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            CraftingHelper.ShapedPrimer primer = RecipeUtils.parsePhaped(context, json);
            ItemStack result = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
            int damage = JsonUtils.func_151204_g((JsonObject)json, (String)"damage") ? JsonUtils.func_151203_m((JsonObject)json, (String)"damage") : 1;
            return new ShapedDamageRecipe(group.isEmpty() ? null : new ResourceLocation(group), primer, result, damage);
        }
    }
}

